import { graphql } from 'react-relay/hooks';
import type { VodInitialProps, VodPathParameters } from 'tachyon-page-utils';
import {
  vodGetInitialProps,
  vodIsFound,
  vodIsNotFoundServerside,
  vodPageviewTracking,
} from 'tachyon-page-utils';
import { PulsarVodPlayer } from '../../Player';
import { pageHeadQueryVariables } from '../../growth';
import { NotFoundErrorLayout, Page, PlayerLayout } from '../../layouts';
import type { TomorrowPage } from '../types';
import { VodPanel } from './VodPanel';
import type { Vod_QueryResponse } from './__generated__/Vod_Query.graphql';

export type VodProps = Vod_QueryResponse & VodInitialProps;

export const Vod: TomorrowPage<VodInitialProps, VodProps, VodPathParameters> =
  ({ video }) => {
    if (!vodIsFound(video)) {
      return <NotFoundErrorLayout />;
    }

    return (
      <Page>
        <PlayerLayout player={<PulsarVodPlayer video={video} />}>
          <VodPanel video={video} />
        </PlayerLayout>
      </Page>
    );
  };

Vod.displayName = 'VodPage';
Vod.isNotFoundServerside = vodIsNotFoundServerside;
Vod.pageviewTracking = vodPageviewTracking;
Vod.totalCacheLife = 1000;
Vod.requiresJsForInteractivity = true;
Vod.getInitialProps = (ctx) =>
  vodGetInitialProps(ctx, pageHeadQueryVariables(ctx));

Vod.query = graphql`
  query Vod_Query($videoId: ID!, $url: String!) {
    video(id: $videoId) {
      ...VodPlayer_video
      ...VodPanel_video
      id
      broadcastType
      createdAt
      game {
        name
      }
      lengthSeconds
      owner {
        id
        login
        displayName
        stream {
          id
        }
      }
      previewThumbnailURL
      title
      viewCount
    }
    ...PageHead_query
  }
`;
