import { datatype, internet, lorem } from 'faker';
import { convertToSafeVideoID } from 'tachyon-relay';
import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { NotFoundErrorLayout, PlayerLayout } from '../../layouts';
import type { Vod_QueryResponse } from './__generated__/Vod_Query.graphql';
import { Vod } from '.';

function getMockVideo(live?: boolean): NonNullable<Vod_QueryResponse['video']> {
  const channelLogin = internet.userName();

  return {
    ' $fragmentRefs': {
      VodPanel_video: true,
      VodPlayer_video: true,
    },
    broadcastType: 'ARCHIVE',
    createdAt: '2019-06-04T12:04:36Z',
    game: {
      name: lorem.words(4),
    },
    id: convertToSafeVideoID(datatype.uuid()),
    lengthSeconds: datatype.number({ max: 2000, min: 1 }),
    owner: {
      displayName: channelLogin.toUpperCase(),
      id: datatype.uuid(),
      login: channelLogin,
      stream: live
        ? {
            id: datatype.uuid(),
          }
        : null,
    },
    previewThumbnailURL:
      'https://static-cdn.jtvnw.net/broadcaster/thumb-{width}x{height}.jpg',
    title: lorem.words(5),
    viewCount: datatype.number({ max: 2000, min: 1 }),
  };
}

describe(Vod, () => {
  const setup = createShallowWrapperFactory(Vod, () => {
    const video = getMockVideo();
    return {
      ' $fragmentRefs': {
        PageHead_query: true,
      },
      queryVariables: {
        url: internet.url(),
        videoId: video.id,
      },
      video,
    };
  });

  it('renders a VOD Player when the video is found', () => {
    const { wrapper } = setup();
    expect(wrapper.find(PlayerLayout)).toExist();
  });

  it('renders a not found page when the video is not found', () => {
    const { wrapper } = setup({ video: null });
    expect(wrapper.find(NotFoundErrorLayout)).toExist();
  });
});
