import { Pageview } from 'tachyon-event-tracker';
import { InternalErrorLayout } from '../../../layouts';

// istanbul ignore next: trival
/**
 * MinimalInternalError does the least possible steps to show a proper error
 * message. It should be used as a last-ditch effort to show an error page
 * before giving up and not rendering anything from the app.
 *
 * Please consult with the Emerging Platforms team before considering using this.
 */
export function MinimalInternalError(): JSX.Element {
  return (
    <>
      <Pageview />
      <InternalErrorLayout />
    </>
  );
}

MinimalInternalError.displayName = 'MinimalInternalError';
