import type { FC } from 'react';
import { InteractionType, useInteractionTracking } from 'tachyon-event-tracker';
import { useIntl } from 'tachyon-intl';
import { useEffectOnce } from 'tachyon-utils';
import {
  AlignItems,
  Color,
  Display,
  FlexDirection,
  JustifyContent,
  Layout,
  Position,
  TextType,
  Title,
  TitleSize,
} from 'twitch-core-ui';
import { Page } from '../../../../layouts';
import { ConnectionIssueSVG } from './ConnectionIssueSVG';

export const FALLBACK_RENDER_INTERACTION = 'render';

// istanbul ignore next: trivial
export const DefaultOfflinePage: FC = () => {
  const trackInteraction = useInteractionTracking();
  const { formatMessage } = useIntl();

  useEffectOnce(() => {
    trackInteraction({
      interaction: InteractionType.Impression,
      interactionContent: FALLBACK_RENDER_INTERACTION,
    });
  });

  return (
    <Page>
      <Layout
        alignItems={AlignItems.Center}
        attachBottom
        attachLeft
        attachRight
        attachTop
        color={Color.Base}
        display={Display.Flex}
        flexDirection={FlexDirection.Column}
        justifyContent={JustifyContent.Center}
        padding={4}
        position={Position.Fixed}
      >
        <ConnectionIssueSVG />
        <Layout padding={{ y: 4 }}>
          <Title size={TitleSize.Default} type={TextType.H1}>
            {formatMessage(
              "Looks like your internet isn't working...",
              'OfflinePageWrapper',
            )}
          </Title>
        </Layout>
      </Layout>
    </Page>
  );
};

DefaultOfflinePage.displayName = 'DefaultOfflinePage';
