import type { FC } from 'react';
import type { AgentInfo, EnvironmentRootProps } from 'tachyon-environment';
import { EnvironmentRoot, Platform, isMobileWeb } from 'tachyon-environment';
import { useRouterUtils } from 'tachyon-next-routing-utils';
import {
  CLIENT_APP,
  ONLINE_STATUS_CHANGE_DELAY_MS,
} from '../../../../../config';
import { isWoodstock } from '../../../../../utils';

type TomorrowEnvironmentRootProps = Pick<
  EnvironmentRootProps['common'],
  'appEnvironment' | 'language'
>;

const PLATFORM = (agentInfo: AgentInfo): Platform =>
  isMobileWeb(agentInfo) ? Platform.MobileWeb : Platform.Web;

export function useTomorrowPlatform(): EnvironmentRootProps['common']['platform'] {
  const { currentPathname, currentQuery } = useRouterUtils();

  if (isWoodstock(currentQuery, currentPathname)) {
    return Platform.Woodstock;
  }

  return PLATFORM;
}

// istanbul ignore next: trivial
export const TomorrowEnvironmentRoot: FC<TomorrowEnvironmentRootProps> = ({
  appEnvironment,
  children,
  language,
}) => {
  const platform = useTomorrowPlatform();

  return (
    <EnvironmentRoot
      children={children}
      common={{
        appEnvironment,
        appVersion: process.env.BUILD_ID,
        clientApp: CLIENT_APP,
        language,
        platform,
      }}
      networkStatusDebounceWait={ONLINE_STATUS_CHANGE_DELAY_MS}
    />
  );
};

TomorrowEnvironmentRoot.displayName = 'TomorrowEnvironmentRoot';
