import { renderHook } from '@testing-library/react-hooks';
import { Platform, isMobileWeb } from 'tachyon-environment';
import { mockRouterUtils, useRouterUtils } from 'tachyon-next-routing-utils';
import {
  WOODSTOCK_QUERY_PARAM_KEY,
  WOODSTOCK_QUERY_PARAM_VALUE,
} from '../../../../../config';
import { RouteLinkPathnames, RouteName } from '../../../../../routing';
import { useTomorrowPlatform } from '.';

jest.mock('tachyon-environment', () => ({
  ...jest.requireActual('tachyon-environment'),
  isMobileWeb: jest.fn(),
}));

jest.mock('tachyon-next-routing-utils', () => ({
  ...jest.requireActual('tachyon-next-routing-utils'),
  useRouterUtils: jest.fn(() => mockRouterUtils),
}));

const isMobileWebMock = isMobileWeb as jest.Mock;
const mockUseRouterUtils = useRouterUtils as jest.Mock;

describe(useTomorrowPlatform, () => {
  it(`${Platform.Woodstock} when query param is present`, () => {
    mockUseRouterUtils.mockImplementationOnce(() => ({
      currentPathname: RouteLinkPathnames[RouteName.ChannelStandalone],
      currentQuery: {
        [WOODSTOCK_QUERY_PARAM_KEY]: WOODSTOCK_QUERY_PARAM_VALUE,
      },
    }));
    const { result } = renderHook(useTomorrowPlatform);

    expect(result.current).toEqual(Platform.Woodstock);
  });

  describe('platform handler', () => {
    it(`${Platform.MobileWeb} when agentInfo is mobile web`, () => {
      isMobileWebMock.mockImplementationOnce(() => true);
      const { result } = renderHook(useTomorrowPlatform);
      const platform = (result.current as () => Platform)();

      expect(platform).toEqual(Platform.MobileWeb);
    });

    it(`${Platform.Web} when agentInfo is not mobile web`, () => {
      isMobileWebMock.mockImplementationOnce(() => false);
      const { result } = renderHook(useTomorrowPlatform);
      const platform = (result.current as () => Platform)();

      expect(platform).toEqual(Platform.Web);
    });
  });
});
