import type { FC } from 'react';
import { useMemo } from 'react';
import { RelayEnvironmentProvider } from 'react-relay/hooks';
import { useCurrentUser } from 'tachyon-auth';
import { useStaticEnvironment } from 'tachyon-environment';
import { useCustomTracking } from 'tachyon-event-tracker';
import type { FetchQueryOpts, RecordMap, RelayEvent } from 'tachyon-relay';
import { initEnvironment } from 'tachyon-relay';
import { getDeviceIDInBrowser, isBrowser } from 'tachyon-utils';

type TomorrowRelayEnvironmentRootProps = {
  fetchQueryOpts: FetchQueryOpts;
  records: RecordMap | undefined;
};

export const TomorrowRelayEnvironmentRoot: FC<TomorrowRelayEnvironmentRootProps> =
  ({ children, fetchQueryOpts, records }) => {
    const { getAuthToken, logout } = useCurrentUser();
    const trackEvent = useCustomTracking<RelayEvent>();
    const {
      common: { appEnvironment },
    } = useStaticEnvironment();

    const environment = useMemo(() => {
      const opts = isBrowser()
        ? {
            fetchQueryOpts: {
              ...fetchQueryOpts,
              authorization:
                appEnvironment === 'production'
                  ? undefined
                  : {
                      token: getAuthToken,
                      unauthorizedHandler: logout,
                    },
              deviceId: getDeviceIDInBrowser(),
              onEvent: trackEvent,
            },
            records,
          }
        : { fetchQueryOpts, records };

      return initEnvironment(opts);
    }, [
      appEnvironment,
      fetchQueryOpts,
      getAuthToken,
      logout,
      records,
      trackEvent,
    ]);

    return (
      <RelayEnvironmentProvider children={children} environment={environment} />
    );
  };

TomorrowRelayEnvironmentRoot.displayName = 'TomorrowRelayEnvironmentRoot';
