import { useCurrentUser } from 'tachyon-auth';
import { initEnvironment } from 'tachyon-relay';
import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { getDeviceIDInBrowser, isBrowser } from 'tachyon-utils';
import { TomorrowRelayEnvironmentRoot } from '.';

jest.mock('tachyon-utils', () => ({
  ...jest.requireActual('tachyon-utils'),
  getDeviceIDInBrowser: jest.fn(),
  isBrowser: jest.fn(),
}));
const mockIsBrowser = isBrowser as jest.Mock;
const mockGetDeviceIDInBrowser = getDeviceIDInBrowser as jest.Mock;

jest.mock('tachyon-auth', () => ({
  useCurrentUser: jest.fn(() => ({})),
}));
const mockUseCurrentUser = useCurrentUser as jest.Mock;

jest.mock('tachyon-relay', () => ({
  ...jest.requireActual('tachyon-relay'),
  initEnvironment: jest.fn(),
}));
const mockInitEnvironment = initEnvironment as jest.Mock;

describe(TomorrowRelayEnvironmentRoot, () => {
  const setup = createShallowWrapperFactory(
    TomorrowRelayEnvironmentRoot,
    () => ({
      fetchQueryOpts: {},
      records: undefined,
    }),
  );

  beforeEach(() => {
    mockInitEnvironment.mockReset();
  });

  it('sets authorization and deviceId when in browser', () => {
    mockIsBrowser.mockImplementationOnce(() => true);
    const logout = jest.fn();
    const getAuthToken = jest.fn(() => 'auth-token');
    mockUseCurrentUser.mockImplementationOnce(() => ({ getAuthToken, logout }));
    const mockDeviceId = 'device-id';
    mockGetDeviceIDInBrowser.mockImplementationOnce(() => mockDeviceId);

    setup();

    expect(mockInitEnvironment).toHaveBeenCalledWith(
      expect.objectContaining({
        fetchQueryOpts: expect.objectContaining({
          authorization: { token: getAuthToken, unauthorizedHandler: logout },
          deviceId: mockDeviceId,
        }),
      }),
    );
  });

  it('does not set set authorization or deviceId when serverside', () => {
    mockIsBrowser.mockImplementationOnce(() => false);
    const { props } = setup();

    expect(mockInitEnvironment).toHaveBeenCalledWith(props);
  });
});
