import type { ErrorInitialProps } from 'tachyon-page-utils';
import {
  defaultPageviewTracking,
  errorGetInitialProps,
} from 'tachyon-page-utils';
import { HTTPStatusCode } from 'tachyon-type-library';
import { InternalErrorLayout, NotFoundErrorLayout } from '../../layouts';
import type { TomorrowPage } from '../types';

export const TomorrowError: TomorrowPage<ErrorInitialProps> = ({
  statusCode,
}) => {
  switch (statusCode) {
    case HTTPStatusCode.NotFound:
      return <NotFoundErrorLayout />;
    case HTTPStatusCode.InternalServerError:
    case HTTPStatusCode.BadGateway:
    default:
      return <InternalErrorLayout />;
  }
};

TomorrowError.displayName = 'TomorrowError';
TomorrowError.pageviewTracking = defaultPageviewTracking;
TomorrowError.requiresJsForInteractivity = false;

// istanbul ignore next: trivial
TomorrowError.getInitialProps = (ctx) =>
  errorGetInitialProps({ package: 'tomorrow' }, ctx);
