import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { HTTPStatusCode } from 'tachyon-type-library';
import { InternalErrorLayout, NotFoundErrorLayout } from '../../layouts';
import { TomorrowError } from '.';

describe(TomorrowError, () => {
  const setup = createShallowWrapperFactory(TomorrowError, () => ({
    statusCode: HTTPStatusCode.InternalServerError,
  }));

  describe('rendering', () => {
    it('renders an <InternalError> on 500 status code', () => {
      const { wrapper } = setup({
        statusCode: HTTPStatusCode.InternalServerError,
      });
      expect(wrapper.find(InternalErrorLayout)).toExist();
    });

    it('renders an <InternalError> on an unexpected status code', () => {
      const { wrapper } = setup({
        statusCode: HTTPStatusCode.VariantAlsoNegotiates,
      });
      expect(wrapper.find(InternalErrorLayout)).toExist();
    });

    it('renders an <NotFoundErrorLayout> on a not found code', () => {
      const { wrapper } = setup({ statusCode: HTTPStatusCode.NotFound });
      expect(wrapper.find(NotFoundErrorLayout)).toExist();
    });
  });
});
