// A URL query parameter that can be added to any fetch request sent within the
// application. Doing so causes our Service Worker to deliver it with
// BackgroundSync if supported by the browser (https://caniuse.com/#feat=background-sync).

const BGSYNC_QUERY_PARAM_KEY = 'allow_stream';
const BGSYNC_QUERY_PARAM_VALUE = 'true';
const BGSYNC_QUERY_PARAM_STRING = `${BGSYNC_QUERY_PARAM_KEY}=${BGSYNC_QUERY_PARAM_VALUE}`;

module.exports = {
  BGSYNC_QUERY_PARAM_KEY,
  BGSYNC_QUERY_PARAM_STRING,
  BGSYNC_QUERY_PARAM_VALUE,
};
