// list should be mirrored in server-side inbound filters
export const IGNORED_ERROR_MESSAGES = [
  // thrown by custom JS in FB/Instagram in-app browser
  "TypeError: Cannot read property 'HTMLInputElement' of undefined",

  // Safari-related native HLS playback errors
  'InvalidStateError: The object is in an invalid state.',

  // Appears this is benign: https://stackoverflow.com/a/50387233
  'ResizeObserver loop limit exceeded',
];

// errors monitored for directionality or further investigation
export const THROTTLED_ERROR_MESSAGES = [
  // tied exclusively to a specific LG Android 4.2.3 device?
  // message is too broad to ignore completely currently for now
  "TypeError: Cannot read property 'src' of null",

  // we just need the directionality of this, not the absolute magnitude
  'Failed GQL request',

  // https://jira.xarth.tv/browse/VP-10581, just need the directionality of this, not the absolute magnitude
  "InvalidStateError: Failed to set the 'duration' property on 'MediaSource': The 'updating' attribute is true on one or more of this MediaSource's SourceBuffers.",
];

// 10%
export const THROTTLED_ERROR_MESSAGE_THRESHOLD = 0.1;
