// The API route configured to accept Flume logs. This should be an absolute
// path so that it is portable between app environments (prod, dev, etc).
// This value _must_ be the same as the route determined via the file-based
// routing config.
export const FLUME_URL = '/api/flume';

// The events we want to track for real-time metrics via flume.
export const FLUME_ALLOWED_EVENTS_FALLBACK = [
  'minute-watched',
  'pageview',
  'video_error',
  'video-play',
];

// The properties that are extracted from events and sent to the Flume endpoint.
// These must not contain any user-identifying data.
export const FLUME_ALLOWED_PROPERTIES_FALLBACK = [
  'app_version',
  'browser_family',
  'browser_version',
  'client_app',
  'content_mode',
  'core_version',
  'location',
  'logged_in',
  'os_name',
  'os_version',
  'platform',
];
