import type { ExperimentBucket } from 'tachyon-experiments';
import type { IntlData } from 'tachyon-intl';

/**
 * Adds extra things to the request object to transport from server app handler to client.
 */
export type TomorrowRequestExtensions = {
  /**
   * Device id captured from cookie or generated on the server
   */
  readonly deviceId: string | undefined;
  /**
   * Experiment bucket ID for the current user.
   */
  readonly experimentBucket: ExperimentBucket | undefined;
  /**
   * The preferred theme read from the theme cookie, if one exists
   */
  readonly initialTheme: string | undefined;
  /**
   * The intlData that was selected as part of the TachyonIntlServer loading process.
   */
  readonly intlData: IntlData;
};
