import { createMountWrapperFactory } from 'tachyon-test-utils';
import { RouteName } from '../routes';
import { mockRouter } from '../test-mocks';
import { Redirect } from '.';

jest.mock('../useTachyonRouter', () => ({
  useTachyonRouter: () => mockRouter,
}));

describe(Redirect, () => {
  const setup = createMountWrapperFactory(Redirect, () => ({
    params: { route: RouteName.Homepage, routeParams: {} } as any,
  }));

  beforeEach(() => {
    jest.resetAllMocks();
  });

  it('pushes', () => {
    const { props } = setup();
    expect(mockRouter.push).toHaveBeenCalledWith(props.params, props.query);
  });

  it('replaces', () => {
    const { props } = setup({ replace: true });
    expect(mockRouter.replace).toHaveBeenCalledWith(props.params, props.query);
  });
});

const mockIsGoogleBot = false;
jest.mock('tachyon-environment', () => ({
  useStaticEnvironment: () => ({
    client: { agentInfo: { satisfies: () => mockIsGoogleBot } },
  }),
}));
