import { ensureValidLinkAndProtocol } from '.';

describe(ensureValidLinkAndProtocol, () => {
  it('returns link with https', () => {
    const href = 'https://example.com';
    expect(ensureValidLinkAndProtocol(href)).toEqual(href);
  });

  it('returns link with http', () => {
    const href = 'http://example.com';
    expect(ensureValidLinkAndProtocol(href)).toEqual(href);
  });

  it('returns undefined for javascript', () => {
    expect(
      ensureValidLinkAndProtocol('javascript:alert("pwned");'),
    ).toBeUndefined();
  });

  it('returns undefined for file', () => {
    expect(ensureValidLinkAndProtocol('file://pwned')).toBeUndefined();
  });

  it('returns undefined without throwing for invalid link', () => {
    expect(ensureValidLinkAndProtocol('invalid')).toBeUndefined();
  });
});
