import type { SingletonRouter } from 'next/router';
import type { TachyonPageContext } from 'tachyon-next-types';
import { pathnameFromRouteName } from '../pathnameFromRouteName';
import { RouteName } from '../routes';

type RouteNameContext =
  | Pick<SingletonRouter, 'pathname'>
  | Pick<TachyonPageContext, 'err' | 'pathname' | 'res'>;

export function pathnameFromContext(ctx?: RouteNameContext): string {
  if (!ctx) {
    return pathnameFromRouteName(RouteName.NotFound);
  }

  // If "res" is on ctx, this is a server context so check for 404s
  if ('res' in ctx && ctx.res) {
    const statusCode = ctx.res.statusCode;

    if (400 <= statusCode && statusCode <= 499) {
      return pathnameFromRouteName(RouteName.NotFound);
    }
  }

  return ctx.pathname;
}
