import { Enum } from 'tachyon-utils';
import { RouteLinkPathnames, RouteName } from '../routes';

/**
 * Converts a Next pathname to a RouteName. Returns NotFound if there is no matching path.
 */
export function routeNameFromPathname(pathname: string): RouteName {
  const routeName = Enum.keys(RouteLinkPathnames).find(
    (route) => RouteLinkPathnames[route] === pathname,
  );

  return routeName ?? RouteName.NotFound;
}
