import { Enum } from 'tachyon-utils';
import { RouteLinkPathnames, RouteName } from '../routes';
import { routeNameFromPathname } from '.';

describe(routeNameFromPathname, () => {
  it.each(Enum.entries(RouteLinkPathnames))(
    'returns %s for path %s',
    (routeName: string, pathname: string) => {
      // coalesce all the profile dupes
      const expected = routeName.includes('placeholder')
        ? RouteName.ChannelHome
        : routeName;
      expect(routeNameFromPathname(pathname)).toEqual(expected);
    },
  );

  it.each(['/foo', '/foo/bar'])(
    `returns ${RouteName.NotFound} for path %s`,
    (pathname: string) => {
      expect(routeNameFromPathname(pathname)).toEqual(RouteName.NotFound);
    },
  );
});
