import { useRouter } from 'next/router';
import { useEffect } from 'react';

export type RouteChangeHandler = (
  path: string,
  opts: { shallow: boolean },
) => void;

/**
 * Subscribe to Next router changes.
 * https://nextjs.org/docs/api-reference/next/router
 */
export function useRouteChange(handler: RouteChangeHandler): void {
  const router = useRouter();

  useEffect(() => {
    router.events.on('routeChangeStart', handler);
    return () => {
      router.events.off('routeChangeStart', handler);
    };
  }, [handler, router.events]);
}
