import { renderHook } from '@testing-library/react-hooks';
import { useRouter } from 'next/router';
import { useRouteChange } from '.';

jest.mock('next/router', () => ({
  useRouter: jest.fn(),
}));

const mockUseRouter = useRouter as jest.Mock;

describe(useRouteChange, () => {
  it('registers the handler', () => {
    const handler = jest.fn();
    const mockOn = jest.fn();
    mockUseRouter.mockImplementation(() => ({
      events: {
        off: jest.fn(),
        on: mockOn,
      },
    }));

    renderHook(useRouteChange, { initialProps: handler });
    expect(mockOn).toHaveBeenCalledWith('routeChangeStart', handler);
  });

  it('unregisters the handler on unmount', () => {
    const handler = jest.fn();
    const mockOff = jest.fn();
    mockUseRouter.mockImplementation(() => ({
      events: {
        off: mockOff,
        on: jest.fn(),
      },
    }));

    const { unmount } = renderHook(useRouteChange, { initialProps: handler });
    unmount();
    expect(mockOff).toHaveBeenCalledWith('routeChangeStart', handler);
  });

  it('unregisters the handler when the handler changes', () => {
    const handler1 = jest.fn();
    const mockOff = jest.fn();
    mockUseRouter.mockImplementation(() => ({
      events: {
        off: mockOff,
        on: jest.fn(),
      },
    }));

    const { rerender } = renderHook(useRouteChange, { initialProps: handler1 });
    rerender(jest.fn());
    expect(mockOff).toHaveBeenCalledWith('routeChangeStart', handler1);
  });
});
