/**
 * Themes correspond to both themes supported in the app and cookie values
 * specifically chosen by the user for a persistent theme experience.
 */
export type BaseTheme =
  /** User has explicitly chosen dark theme */
  | 'dark'
  /** User has explicitly chosen light theme */
  | 'light';

/**
 * Themes corresponding to indications from querying the device's
 * prefers-color-scheme support.
 */
export type PreferredTheme =
  /** User's device last preferred dark theme */
  | 'dark_preferred'
  /** User's device last preferred light theme */
  | 'light_preferred';

export type Theme = BaseTheme | PreferredTheme;
export type SetTheme = (nextTheme: Theme) => void;

export function convertPreferredThemeToBaseTheme(theme: Theme): BaseTheme {
  return theme.split('_')[0] as BaseTheme;
}

export const AllThemes: Theme[] = [
  'dark',
  'dark_preferred',
  'light',
  'light_preferred',
];
