import { createContext } from 'react';
import { DEFAULT_THEME } from '../config';
import type { BaseTheme } from './Theme';
import { convertPreferredThemeToBaseTheme } from './Theme';

export interface ThemeContext {
  currentTheme: BaseTheme;
  toggleTheme: () => void;
}

export const themeContext = createContext<ThemeContext>({
  currentTheme: convertPreferredThemeToBaseTheme(DEFAULT_THEME),
  toggleTheme: () => undefined,
});
