import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { DEFAULT_THEME } from '../../config';
import { convertPreferredThemeToBaseTheme } from '../Theme';
import { ThemeRoot } from '.';

describe('Themes', () => {
  const setup = createShallowWrapperFactory(ThemeRoot, () => ({
    initialTheme: undefined,
  }));

  describe('setting context and first render', () => {
    it('uses default without initial theme', () => {
      const { wrapper } = setup();

      expect(
        wrapper.find(
          `.tw-root--theme-${convertPreferredThemeToBaseTheme(DEFAULT_THEME)}`,
        ),
      ).toExist();
    });

    it('uses passed in dark theme', () => {
      const { wrapper } = setup({ initialTheme: 'dark' });

      expect(wrapper.find('.tw-root--theme-dark')).toExist();
    });

    it('uses passed in dark_preferred theme', () => {
      const { wrapper } = setup({ initialTheme: 'dark_preferred' });

      expect(wrapper.find('.tw-root--theme-dark')).toExist();
    });

    it('uses passed in light theme', () => {
      const { wrapper } = setup({ initialTheme: 'light' });

      expect(wrapper.find('.tw-root--theme-light')).toExist();
    });

    it('uses passed in light_preferred theme', () => {
      const { wrapper } = setup({ initialTheme: 'light_preferred' });

      expect(wrapper.find('.tw-root--theme-light')).toExist();
    });
  });
});
