import { DEFAULT_THEME } from '../../config';
import type { Theme } from '../Theme';
import { AllThemes } from '../Theme';

function isStringATheme(maybeTheme: Theme | string): maybeTheme is Theme {
  return AllThemes.includes(maybeTheme as Theme);
}

export function validateTheme(maybeTheme: string | undefined): Theme {
  if (!maybeTheme) {
    return DEFAULT_THEME;
  }
  return isStringATheme(maybeTheme) ? maybeTheme : DEFAULT_THEME;
}
