import { DEFAULT_THEME } from '../../config';
import { validateTheme } from '.';

describe(validateTheme, () => {
  it('returns a valid theme passed', () => {
    expect(validateTheme('light')).toEqual('light');
    expect(validateTheme('light_preferred')).toEqual('light_preferred');
    expect(validateTheme('dark')).toEqual('dark');
    expect(validateTheme('dark_preferred')).toEqual('dark_preferred');
  });

  it('returns the default theme for an invalid theme', () => {
    expect(validateTheme('blue')).toEqual(DEFAULT_THEME);
  });

  it('returns the default theme for undefined', () => {
    expect(validateTheme(undefined)).toEqual(DEFAULT_THEME);
  });
});
