import { getCookieComplexValue } from 'tachyon-utils';

export const TWILIGHT_USER_COOKIE = 'twilight-user';

type TwilightUserCookie = {
  authToken: string;
  displayName: string;
  id: string;
  login: string;
  roles: {
    isStaff: boolean;
  };
  version: number;
};

/**
 * Deserializes the twilight-user cookie if present. This is helpful when piggy backing off of Twilight login
 * for local development
 */
export function getTwilightUserCookie(): TwilightUserCookie | undefined {
  return getCookieComplexValue({ name: TWILIGHT_USER_COOKIE });
}
