import { TWILIGHT_USER_COOKIE, getTwilightUserCookie } from '.';

describe(getTwilightUserCookie, () => {
  it('deserializes the user cookie', () => {
    window.document.cookie = `${TWILIGHT_USER_COOKIE}={%22authToken%22:%22foo%22%2C%22displayName%22:%22tatethurston%22%2C%22id%22:%22522347852%22%2C%22login%22:%22tatethurston%22%2C%22roles%22:{%22isStaff%22:true}%2C%22version%22:2}`;

    expect(getTwilightUserCookie()).toEqual({
      authToken: 'foo',
      displayName: 'tatethurston',
      id: '522347852',
      login: 'tatethurston',
      roles: {
        isStaff: true,
      },
      version: 2,
    });

    window.document.cookie = '';
  });
});
