import { isBrowser } from 'tachyon-utils';
import { INSTALLED_DISPLAY_MODE } from '../../config';

export function isStandaloneApp(): boolean {
  return (
    isBrowser() &&
    // standard check (works on FF + Chrome)
    (('matchMedia' in window &&
      window.matchMedia(`(display-mode: ${INSTALLED_DISPLAY_MODE})`).matches) ||
      // nonstandard check for Safari
      // https://developer.apple.com/library/archive/documentation/AppleApplications/Reference/SafariWebContent/ConfiguringWebApplications/ConfiguringWebApplications.html
      ('standalone' in window.navigator && window.navigator.standalone))
  );
}
