import { isBrowser } from 'tachyon-utils';
import { isStandaloneApp } from '.';

jest.mock('tachyon-utils', () => ({
  ...jest.requireActual('tachyon-utils'),
  isBrowser: jest.fn(),
}));
const mockIsBrowser = isBrowser as jest.Mock;

describe(isStandaloneApp, () => {
  afterEach(() => {
    // @ts-expect-error: tests
    delete window.matchMedia;
    // @ts-expect-error: tests
    delete window.navigator.standalone;
  });

  it('false when not browser', () => {
    mockIsBrowser.mockImplementationOnce(() => false);

    expect(isStandaloneApp()).toEqual(false);
  });

  it('true when display-mode: standalone', () => {
    mockIsBrowser.mockImplementationOnce(() => true);
    window.matchMedia = jest.fn(() => ({ matches: true })) as any;
    window.navigator.standalone = false;

    expect(isStandaloneApp()).toEqual(true);
  });

  it('true when navigator.standalone', () => {
    mockIsBrowser.mockImplementationOnce(() => true);
    window.matchMedia = jest.fn(() => ({ matches: false })) as any;
    window.navigator.standalone = true;

    expect(isStandaloneApp()).toEqual(true);
  });
});
