import type { ParsedUrlQuery } from 'querystring';
import { flattenHeaderOrParam } from 'tachyon-utils';
import {
  WOODSTOCK_QUERY_PARAM_KEY,
  WOODSTOCK_QUERY_PARAM_VALUE,
} from '../../config';
import { RouteName, routeNameFromPathname } from '../../routing';

export function isWoodstock(
  currentQuery: ParsedUrlQuery,
  currentPathname: string,
): boolean {
  return (
    routeNameFromPathname(currentPathname) === RouteName.ChannelStandalone &&
    flattenHeaderOrParam(currentQuery[WOODSTOCK_QUERY_PARAM_KEY]) ===
      WOODSTOCK_QUERY_PARAM_VALUE
  );
}
