import {
  WOODSTOCK_QUERY_PARAM_KEY,
  WOODSTOCK_QUERY_PARAM_VALUE,
} from '../../config';
import { RouteLinkPathnames, RouteName } from '../../routing';
import { isWoodstock } from '.';

describe(isWoodstock, () => {
  it('true when on the ChannelStandalone page and the WoodStock query param is present', () => {
    const currentQuery = {
      [WOODSTOCK_QUERY_PARAM_KEY]: WOODSTOCK_QUERY_PARAM_VALUE,
    };

    const currentPathname = RouteLinkPathnames[RouteName.ChannelStandalone];

    expect(isWoodstock(currentQuery, currentPathname)).toEqual(true);
  });

  it('false when not on the ChannelStandalone page', () => {
    const currentQuery = {
      [WOODSTOCK_QUERY_PARAM_KEY]: WOODSTOCK_QUERY_PARAM_VALUE,
    };

    const currentPathname = 'real-fake-route';

    expect(isWoodstock(currentQuery, currentPathname)).toEqual(false);
  });

  it('false when woodstock query param != WOODSTOCK_QUERY_PARAM_VALUE', () => {
    const currentQuery = {
      [WOODSTOCK_QUERY_PARAM_KEY]: 'real-fake-param-value',
    };

    const currentPathname = RouteLinkPathnames[RouteName.ChannelStandalone];

    expect(isWoodstock(currentQuery, currentPathname)).toEqual(false);
  });
});
