import type { DeepLinkData } from 'branch-sdk';
import { useLink } from 'react-branch';
import { useStaticEnvironment } from 'tachyon-environment';
import { useRouterUtils } from 'tachyon-next-routing-utils';
import { routeNameFromPathname } from '../../routing';
import { buildDeepLinkURL, getDeeplinkableOS } from './utils';
import type { DeeplinkableOS } from './utils';

export const BRANCH_CHANNEL = 'mobile_web';

/**
 * builds the fallback url for when branch is unavaibale or fails
 */
const getFallbackUrl = (
  deepLinkableOS: DeeplinkableOS | null,
  campaign: string,
  callToActionIdentifier: string,
) => {
  if (!deepLinkableOS) {
    return null;
  }

  return buildDeepLinkURL({
    appStoreOpts: {
      callToActionIdentifier,
      campaign,
      os: deepLinkableOS,
    },
    path: window.location.pathname,
    referrer: window.location.href,
  });
};
export const useDeepLink = (
  campaign: string,
  callToActionIdentifier: string,
  targetAppLocation?: string,
  linkData?: DeepLinkData,
): string | null => {
  const { client: clientEnv } = useStaticEnvironment();
  const { currentPathname } = useRouterUtils();
  const currentRouteName = routeNameFromPathname(currentPathname);

  const inAppLocation = targetAppLocation ?? currentRouteName;

  const deepLinkableOS = getDeeplinkableOS(clientEnv.agentInfo);

  const [deepLink] = useLink({
    campaign,
    channel: BRANCH_CHANNEL,
    data: {
      ...linkData,
      app_session_id: clientEnv.sessionID,
      device_id: clientEnv.deviceID,
    },
    feature: inAppLocation,
  });

  return deepLinkableOS
    ? deepLink ??
        getFallbackUrl(deepLinkableOS, inAppLocation, callToActionIdentifier)
    : null;
};
