import { renderHook } from '@testing-library/react-hooks';
import {
  getAndroidEnvMock,
  getOtherEnvMock,
  getiOSEnvMock,
} from 'tachyon-environment';
import { useDeepLink } from '.';

let mockEnvironment = getiOSEnvMock();
jest.mock('tachyon-environment', () => ({
  ...jest.requireActual('tachyon-environment'),
  useStaticEnvironment: () => mockEnvironment,
}));

let mockBranchUrl: string | null = 'https://test.branch.url';
jest.mock('react-branch', () => ({
  ...jest.requireActual('react-branch'),
  useLink: () => [mockBranchUrl],
}));

jest.mock('tachyon-next-routing-utils', () => ({
  ...jest.requireActual('tachyon-next-routing-utils'),
  useRouterUtils: () => ({ currentPathName: '/[login]' }),
}));

describe(useDeepLink, () => {
  afterEach(() => {
    mockBranchUrl = 'https://test.branch.url';
    mockEnvironment = getiOSEnvMock();
  });
  it('returns a branch link when branch is available', () => {
    const { result } = renderHook(() =>
      useDeepLink('test_branch_campaign', 'test'),
    );
    expect(result.current).toEqual(mockBranchUrl);
  });

  it('returns a fallback url when branch is not available', () => {
    mockBranchUrl = null;
    const { result } = renderHook(() =>
      useDeepLink('test_branch_campaign', 'test'),
    );
    expect(result.current).toEqual(
      expect.stringContaining('https://apps.apple.com'),
    );
  });
  it('returns branch url when the OS is a valid deeplink OS', () => {
    mockEnvironment = getAndroidEnvMock();
    const { result } = renderHook(() =>
      useDeepLink('test_branch_campaign', 'test'),
    );
    expect(result.current).toEqual(mockBranchUrl);
  });

  it('returns null when the OS is not a valid deeplink OS', () => {
    mockEnvironment = getOtherEnvMock();
    const { result } = renderHook(() =>
      useDeepLink('test_branch_campaign', 'test'),
    );
    expect(result.current).toBeNull();
  });
});
