/**
 * This development service worker exists for DX.
 *
 * This replaces the service-worker.js that is created after running `yarn prodlike`. Without this, developers would need to remember to manually delete the generated service worker so that it does not serve stale assets.
 *
 * https://git.xarth.tv/pages/emerging-platforms/tachyon/d/apps/tomorrow/processes/service-worker-development/
 */

// Immediately take over all clients (skipWaiting and clients.claim()) in local development so that
// an outdated service-worker from previously running `yarn prodlike` doesn't troll us.

self.addEventListener('install', () => {
  self.skipWaiting();
});

self.addEventListener('activate', (event) => {
  // eslint-disable-next-line no-undef
  event.waitUntil(clients.claim());
});

// eslint-disable-next-line no-console
console.info(
  '[src/development-service-worker.js] The service worker has been disabled for development. Run `yarn prodlike` to test the service worker locally.',
);
