# Tachyon Valence

Twitch's video-embed app for Prospero. It is intended to run inside of an iframe
in target consumers.

## Setting Up Valence

1. Run through the
   [First Time Setup](https://git.xarth.tv/pages/emerging-platforms/tachyon#getting-started)
   for Tachyon which includes necessary Valence setup.
1. Run `yarn start` from the root of the app directory and visit the app in the
   browser at: https://localhost.valence.tv.twitch.tv.

## App Architecture

### Major Technology choices

- Framework, Build Process, and Server-Side Rendering:
  [Next.js](https://nextjs.org/docs/#setup).
- View Layer: [React](https://reactjs.org/docs/getting-started.html).
- Twitch API Access
  [Relay Modern](https://facebook.github.io/relay/docs/en/introduction-to-relay.html).

### Public Consumer API

A consumer is able to interact with Valence through the
[postMessage](https://developer.mozilla.org/en-US/docs/Web/API/Window/postMessage)
API. This
[types](https://git.xarth.tv/emerging-platforms/tachyon/blob/main/apps/valence/src/components/controller/types.ts)
file indicates the events types and shapes that are supported.

### Valence-Specific Configuration

Valence is different from most of the other tachyon apps in that it is
configured to utilize the bare minimum to provide the necessary experience. As
it result, it has the following differences:

- No core-ui or styled-components, instead using raw CSS in `<style>` tags
- No i18n, since it doesn't have any text
- No experimentation framework
- All errors are intentionally a black screen state so that load/playback
  failure can fade into the background of its use-case
- All GraphQL responses go down the "partial success" pathway, attempting to
  render regardless of errors in the response payload (basically always trying
  to get to video playback if at all possible)
- No Polyfill service, since the app's narrow target is known and doesn't need
  it
- No user-specific values are accessed on the server in order to minimize the
  number of cache splits necessary for this app.

### Valence Security

As Valence runs a Twitch video stream without any branding, we need to ensure
that it won't run in arbitrary places on the web. As a result, it employs the
following security practices to help minimize that risk (using a shared
`ALLOWED_ORIGINS` set in config):

1. [Content-Security-Policy frame-ancestors](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Content-Security-Policy/frame-ancestors)
   is set with the domains we expect to validly iframe this application. This
   should prevent most invalid use-cases.
1. Upon boot, the app detects whether it is in a valid iframe. If it is in an
   invalid iframe (somehow bypassing CSP) or it is not in an iframe at all, it
   redirects to the homepage (which is a black screen in production).
1. All messages received via postMessage have their origins validated, and any
   that come from an invalid use-case are ignored, protecting against both
   invalid parents (which somehow bypassed CSP) as well as top-level domain
   usage.

### Build A Valence Documentation Bundle

Running `yarn bundle` generates a documentation bundle containing a sample app
that consumes Valence and the types file for Valence's postMessage interface.

## Local Development

### Running Locally

```sh
$ yarn start
```

Note for Firefox users: In order to support HTTPS in local development, we use a
self-signed certificate that is added to your system keychain. Because Firefox
maintains its own keychain, when your browser first attempts to load the app it
will attempt to prevent you from visiting the site. You will need to override
its warning by clicking the "Advanced" button on this error page:

![iOS Simulator Manage Devices](../../apps/sky-map/public/static/tomorrow/processes/local-development/ff-untrusted-https-page.png)

#### Testing Iframing Locally

To test iframe functionality, use the
[valence package-example](../../../package-examples/valence). The valence app's
local nginx proxy is set up to also provide a proxy for that package, so once
this app is running you can start the example to have a testing playground for
working with postMessage-based control.

#### Simulating A Production Build Locally

If you need to run Valence locally as a fully optimized production build:

```sh
$ yarn prodlike
```

#### Running A Production Environment Locally

If you need to run a full Docker Valence environment locally, from the root of
Tachyon:

```sh
$ yarn docker:vlc
```

Then visit `localhost:3003`.

### Running Unit Tests

Tachyon uses [Jest](https://jestjs.io/docs/en/cli) to run unit tests:

```sh
$ yarn test [TestPathPattern]
```

Or for watch mode:

```sh
$ yarn test:watch [TestPathPattern]
```

### Code Formatting

#### Linting via [ESLint](https://eslint.org/)

```sh
$ yarn lint:fix
```

_Note: Integrate ESLint into your IDE for the best experience._

## Bundling Reference Files for Partners

We send the type definitions for the command and event messages along with the
example usage implementation to our partners as documentation. To generate a
bundle of these files, just use:

```sh
yarn bundle
```

and `valence.zip` will be output into the `dist/` directory.
