const { resolve } = require('path');
const { transforms } = require('./env.config.js');

module.exports = (api) => {
  api.cache.using(() => process.env.NODE_ENV);
  const isTest = api.env('test');

  const presetEnvOpts = {
    debug: api.env('development'),
    targets: !isTest && {
      browsers: ['Safari >= 13'],
      node: '14.15',
    },
  };

  if (api.env('prenext')) {
    presetEnvOpts.modules = 'commonjs';
  }

  const nextBabelOpts = {
    'preset-env': presetEnvOpts,
  };

  const presets = [['next/babel', nextBabelOpts]];

  const plugins = ['relay', ['transform-define', transforms]];

  return {
    plugins,
    presets,
    sourceType: 'unambiguous',
  };
};
