const { join } = require('path');
const { readIniFile } = require('tachyon-server-utils');

const {
  auth: { dsn: sentryDsn },
} = readIniFile(join(__dirname, '.sentryclirc'));

const buildId = process.env.GIT_COMMIT
  ? `vlc-${process.env.GIT_COMMIT.slice(0, 7)}`
  : 'vlc-dev';

const transforms = {
  'process.env.BUILD_ID': buildId,
  'process.env.SENTRY_DSN': sentryDsn,
};

module.exports = {
  buildId,
  transforms,
};
