import { join } from 'path';
import { createReadStream, createWriteStream } from 'fs';
import { ensureDirSync } from 'fs-extra';
import archiver from 'archiver';

const distDir = join(__dirname, '../dist');
const zipDest = join(distDir, "valence.zip");
const exampleFile = join(__dirname, '../../../package-examples/valence/src/index.tsx');
const exampleFilename = 'example.tsx';
const typesFile = join(__dirname, '../src/components/controller/types.ts');
const typesFilename = 'types.ts';

ensureDirSync(distDir);
const output = createWriteStream(zipDest);
const archive = archiver('zip', { zlib: { level: 9 } });

output.on('close', function() {
  console.log(`Valence example generated at dist/valence.zip: ${archive.pointer()} bytes`);
});

archive.pipe(output);
archive.append(createReadStream(exampleFile), { name: exampleFilename });
archive.append(createReadStream(typesFile), { name: typesFilename });
archive.finalize();
