import { createContext, useContext } from 'react';
import type { LoadedEventData } from './types';
import type { sendEvent } from './utils';

export type ControllerContext = {
  onLoad: (data: LoadedEventData) => void;
  onPlayerEvent: typeof sendEvent;
};

// istanbul ignore next: trivial
export const controllerContext = createContext<ControllerContext>({
  onLoad: () => undefined,
  onPlayerEvent: () => undefined,
});

// istanbul ignore next: trivial
export function useControllerContext(): ControllerContext {
  return useContext(controllerContext);
}
