import { random } from 'faker';
import { isAllowedOrigin } from '.';

jest.mock('../../../../config', () => ({
  ALLOWED_ORIGINS: ['https://local.twitch', 'https://*.wildcard.sony'],
}));

describe(isAllowedOrigin, () => {
  describe('fully specified entry', () => {
    it('passes exact match', () => {
      expect(isAllowedOrigin('https://local.twitch')).toBeTruthy();
    });

    it('passes exact match with trailing slash', () => {
      expect(isAllowedOrigin('https://local.twitch/')).toBeTruthy();
    });

    it('fails with wrong protocol', () => {
      expect(isAllowedOrigin('http://local.twitch')).toBeFalsy();
    });

    it('fails with subdomain', () => {
      expect(isAllowedOrigin('http://sub.local.twitch')).toBeFalsy();
    });

    it('fails when domain is actually a subdomain', () => {
      expect(isAllowedOrigin('http://local.twitch.evil')).toBeFalsy();
    });
  });

  describe('wildcard entry', () => {
    it('passes arbitrary subdomain', () => {
      expect(
        isAllowedOrigin(`https://${random.alphaNumeric()}.wildcard.sony`),
      ).toBeTruthy();
    });

    it('passes arbitrary subdomain with trailing slash', () => {
      expect(
        isAllowedOrigin(`https://${random.alphaNumeric()}.wildcard.sony/`),
      ).toBeTruthy();
    });

    it('fails with wrong protocol', () => {
      expect(
        isAllowedOrigin(`http://${random.alphaNumeric()}.wildcard.sony`),
      ).toBeFalsy();
    });

    it('fails without subdomain', () => {
      expect(isAllowedOrigin('https://wildcard.sony')).toBeFalsy();
    });

    it('fails when domain is actually a subdomain', () => {
      expect(
        isAllowedOrigin(`https://${random.alphaNumeric()}.wildcard.sony.evil`),
      ).toBeFalsy();
    });
  });
});
