import type { AppEnvironment } from 'tachyon-environment';
import { isAllowedOrigin } from './isAllowedOrigin';

// istanbul ignore next: cost outweighs value
export function isUnauthorizedAccess(appEnvironment: AppEnvironment): boolean {
  // bail out if on server or not in production
  if (
    typeof window === 'undefined' ||
    process.env.NODE_ENV !== 'production' ||
    appEnvironment !== 'production'
  ) {
    return false;
  }

  // if we're not in a iframe on an allowed origin, we're unauthorized
  return window.self === window.top || !isAllowedOrigin(document.referrer);
}
