import type { InboundCommand } from '../../types';

function isInboundCommand(data: unknown): data is InboundCommand {
  // despite being truthy, TS thinks data (as unknown) could still be null, forcing a cast
  return !!data && typeof data === 'object' && 'command' in (data as any);
}

export function parseControllerCommand(
  rawData: unknown,
): InboundCommand | null {
  if (!rawData || typeof rawData !== 'string') {
    return null;
  }

  let data;
  try {
    data = JSON.parse(rawData) as unknown;
  } catch {
    return null;
  }

  return isInboundCommand(data) ? data : null;
}
