import type { InboundCommand } from '../../types';
import { parseControllerCommand } from '.';

describe(parseControllerCommand, () => {
  it('returns null when data is missing', () => {
    expect(parseControllerCommand(undefined)).toBeNull();
  });

  it('returns null when data is not a string', () => {
    expect(parseControllerCommand(true)).toBeNull();
    expect(parseControllerCommand({})).toBeNull();
    expect(parseControllerCommand(3)).toBeNull();
  });

  it('returns null when data is unparseable string', () => {
    expect(parseControllerCommand('}')).toBeNull();
  });

  it('returns null when parsed data is empty', () => {
    expect(parseControllerCommand('""')).toBeNull();
  });

  it('returns null when parsed data is not an object', () => {
    expect(parseControllerCommand('2')).toBeNull();
    expect(parseControllerCommand('true')).toBeNull();
    expect(parseControllerCommand('"string"')).toBeNull();
  });

  it('returns null when parsed data is an array', () => {
    expect(parseControllerCommand('[]')).toBeNull();
  });

  it('returns null when parsed data is an object without a command', () => {
    expect(parseControllerCommand('{}')).toBeNull();
    expect(parseControllerCommand(JSON.stringify({ cmd: 'obey' }))).toBeNull();
  });

  it('returns a properly formatted command', () => {
    const command: InboundCommand = { command: 'play' };
    expect(parseControllerCommand(JSON.stringify(command))).toEqual(command);
  });
});
