import { isBrowser } from 'tachyon-utils';
import type { OutboundEvent } from '../../types';

export function sendEvent<
  EventName extends OutboundEvent['event'],
  Event extends Extract<OutboundEvent, { event: EventName }>,
>(
  ...[event, data]: Event extends { data: unknown }
    ? [Event['event'], Event['data']]
    : [Event['event']]
): void {
  if (isBrowser()) {
    const payload = data !== undefined ? { data, event } : { event };
    window.parent.postMessage(JSON.stringify(payload), '*');
  }
}
