import type { OutboundEvent } from '../../types';
import { sendEvent } from '.';

describe(sendEvent, () => {
  let ogPostMessage: typeof window.parent.postMessage;
  let mockPostMessage: jest.Mock;
  beforeAll(() => {
    // eslint-disable-next-line @typescript-eslint/unbound-method
    ogPostMessage = window.parent.postMessage;
    mockPostMessage = jest.fn();
    window.parent.postMessage = mockPostMessage;
  });

  afterAll(() => {
    window.parent.postMessage = ogPostMessage;
  });

  it('calls postMessage for simple event with stringified data and a wildcard domain', () => {
    const payload: OutboundEvent = { event: 'init' };
    sendEvent(payload.event);
    expect(mockPostMessage).toHaveBeenCalledTimes(1);
    expect(mockPostMessage).toHaveBeenCalledWith(JSON.stringify(payload), '*');
  });

  it('calls postMessage for data event with stringified data and a wildcard domain', () => {
    const payload: OutboundEvent = { data: true, event: 'mutedSet' };
    sendEvent(payload.event, payload.data);
    expect(mockPostMessage).toHaveBeenCalledTimes(1);
    expect(mockPostMessage).toHaveBeenCalledWith(JSON.stringify(payload), '*');
  });
});
