import { internet, lorem } from 'faker';
import { validId } from 'tachyon-relay';
import { createMountWrapperFactory } from 'tachyon-test-utils';
import { StreamPlayerManager } from '../../player';
import { Channel } from '.';

jest.mock('../../player', () => ({
  StreamPlayerManager: jest.fn(() => <div />),
}));

const mockOnPlayerEvent = jest.fn();
jest.mock('../../controller', () => ({
  useControllerContext: () => ({
    onPlayerEvent: mockOnPlayerEvent,
  }),
}));

describe(Channel, () => {
  beforeEach(() => {
    mockOnPlayerEvent.mockReset();
  });

  describe('render', () => {
    const setup = createMountWrapperFactory(Channel, () => ({
      channel: {
        ' $fragmentRefs': { StreamPlayerManager_channel: true },
        hosting: null,
        id: validId(),
        login: internet.userName(),
        stream: null,
      },
      queryVariables: {
        login: lorem.word(),
      },
    }));

    describe('player renders', () => {
      it('user with own stream', () => {
        const { wrapper } = setup({
          channel: { stream: { id: validId() } },
        });

        expect(wrapper.find(StreamPlayerManager)).toHaveLength(1);
      });

      it('user with hosted stream', () => {
        const { wrapper } = setup({
          channel: {
            hosting: {
              id: validId(),
              login: internet.userName(),
              stream: { id: validId() },
            },
          },
        });

        expect(wrapper.find(StreamPlayerManager)).toHaveLength(1);
      });
    });
  });
});
