import { graphql } from 'react-relay/hooks';
import type { TachyonPage } from 'tachyon-next-types';
import type { ClipInitialProps, ClipPathParameters } from 'tachyon-page-utils';
import {
  clipGetInitialProps,
  clipIsFound,
  clipIsNotFoundServerside,
  clipPageviewTracking,
} from 'tachyon-page-utils';
import { MainVideoContainer } from '../../common';
import { useControllerContext } from '../../controller';
import { ClipPlayerManager } from '../../player';
import type { Clip_QueryResponse } from './__generated__/Clip_Query.graphql';

type ClipProps = Clip_QueryResponse & ClipInitialProps;

// istanbul ignore next: trivial
export const Clip: TachyonPage<
  ClipInitialProps,
  ClipProps,
  ClipPathParameters
> = ({ clip }) => {
  const { onPlayerEvent } = useControllerContext();

  if (!clipIsFound(clip)) {
    // Treat a GraphQL error as a video error since it should be retryable:
    // 1) It's the consumer's responsibility to only request content that exists.
    // 2) We can't distinguish between 404 / 5xx errors in GQL. Assume it's the
    //    latter since the consumer should only be requesting valid content.
    onPlayerEvent('videoErrored');
    return null;
  }

  return (
    <MainVideoContainer>
      <ClipPlayerManager clip={clip} />
    </MainVideoContainer>
  );
};

Clip.displayName = 'Clip';
Clip.getInitialProps = clipGetInitialProps;
Clip.isNotFoundServerside = clipIsNotFoundServerside;
Clip.pageviewTracking = clipPageviewTracking;

Clip.query = graphql`
  query Clip_Query($slug: ID!) {
    clip(slug: $slug) {
      ...ClipPlayerManager_clip
      id
      broadcaster {
        id
        login
      }
      game {
        name
      }
      slug
    }
  }
`;
