import { internet, lorem } from 'faker';
import { validId } from 'tachyon-relay';
import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { ClipPlayerManager } from '../../player';
import { Clip } from '.';

const mockOnPlayerEvent = jest.fn();
jest.mock('../../controller', () => ({
  useControllerContext: () => ({
    onPlayerEvent: mockOnPlayerEvent,
  }),
}));

describe(Clip, () => {
  beforeEach(() => {
    mockOnPlayerEvent.mockReset();
  });

  describe('render', () => {
    const slug = lorem.word();

    const setup = createShallowWrapperFactory(Clip, () => ({
      clip: {
        ' $fragmentRefs': { ClipPlayerManager_clip: true },
        broadcaster: {
          id: validId(),
          login: internet.userName(),
        },
        game: {
          name: internet.userName(),
        },
        id: validId(),
        slug,
      },
      queryVariables: { slug },
    }));

    it('empty renders when clip is not found and emits a videoError', () => {
      const { wrapper } = setup({ clip: null });

      expect(mockOnPlayerEvent).toHaveBeenCalledTimes(1);
      expect(mockOnPlayerEvent).toHaveBeenCalledWith('videoErrored');
      expect(wrapper).toBeEmptyRender();
    });

    it('renders when clip is found', () => {
      const { wrapper } = setup();
      expect(wrapper.find(ClipPlayerManager)).toExist();
    });
  });
});
