import type { TachyonPage } from 'tachyon-next-types';
import { defaultPageviewTracking } from 'tachyon-page-utils';

/**
 * Health check page renderer.
 *
 * This just renders an okay message if it succeeds. If it fails then the
 * health check would fail and this instance of valence would stop receiving
 * traffic.
 */
export const HealthCheck: TachyonPage = () => {
  // The rendered content doesn't actually matter, health checks should
  // only be using the status code. If we have a more complicated system
  // later we may want to make this into a table of status checks so that a
  // human looking at it could see why we got an unexpected status code.
  return <main>ok</main>;
};

HealthCheck.displayName = 'HealthCheck';
HealthCheck.pageviewTracking = defaultPageviewTracking;

/**
 * If run on server will reach into context to set a no-store cache header.
 *
 * Returns an empty object since HealthCheck requires no context.
 */
HealthCheck.getInitialProps = ({ res }) => {
  if (res) {
    // Do not store the request or response in non-volatile memory.
    // See section 5.2.1.5 https://tools.ietf.org/html/rfc7234#section-5.2
    res.setHeader('Cache-Control', 'no-store');
  }

  // Next requires us to return some initial props even if we don't really
  // have any.
  return {};
};
